/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.terminal.internal.emulator;

import com.aptana.terminal.internal.emulator.TextCanvas;
import com.aptana.terminal.internal.emulator.ThemedTextLineRenderer;
import com.aptana.terminal.internal.hyperlink.HyperlinkManager;
import java.io.UnsupportedEncodingException;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.tm.internal.terminal.control.ITerminalListener;
import org.eclipse.tm.internal.terminal.provisional.api.ITerminalConnector;
import org.eclipse.tm.internal.terminal.textcanvas.ILinelRenderer;
import org.eclipse.tm.internal.terminal.textcanvas.ITextCanvasModel;

public class VT100TerminalControl
extends org.eclipse.tm.internal.terminal.emulator.VT100TerminalControl {
    private static final Set<Character> IGNORE_ALT_WITH_KEYS = new HashSet<Character>();
    private IEclipsePreferences.IPreferenceChangeListener preferenceChangeListener;
    private IPropertyChangeListener propertyChangeListener;
    private HyperlinkManager hyperlinkManager;

    static {
        char[] cArray = "@#\\|[]{}".toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            IGNORE_ALT_WITH_KEYS.add(Character.valueOf(c));
            ++n2;
        }
    }

    public VT100TerminalControl(ITerminalListener target, Composite wndParent, ITerminalConnector[] connectors) {
        super(target, wndParent, connectors);
        this.getRootControl().setBackground(ThemedTextLineRenderer.getStyleMap().getBackgroundColor());
        this.preferenceChangeListener = new IEclipsePreferences.IPreferenceChangeListener(){

            public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
                Control control;
                if ("THEME_CHANGED".equals(event.getKey()) && !(control = VT100TerminalControl.this.getRootControl()).isDisposed()) {
                    control.setBackground(ThemedTextLineRenderer.getStyleMap().getBackgroundColor());
                    VT100TerminalControl.this.getCtlText().redraw();
                }
            }
        };
        InstanceScope.INSTANCE.getNode("com.aptana.theme").addPreferenceChangeListener(this.preferenceChangeListener);
        this.propertyChangeListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if ("org.eclipse.jface.textfont".equals(event.getProperty())) {
                    VT100TerminalControl.this.setFont(JFaceResources.getTextFont());
                }
            }
        };
        JFaceResources.getFontRegistry().addListener(this.propertyChangeListener);
        this.getCtlText().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                String text;
                if (e.button == 2 && (text = (String)VT100TerminalControl.this.getClipboard().getContents((Transfer)TextTransfer.getInstance(), 2)) != null && text.length() > 0) {
                    VT100TerminalControl.this.pasteString(text);
                }
            }
        });
    }

    public void setEncoding(String encoding) throws UnsupportedEncodingException {
        if (encoding == null) {
            encoding = "UTF-8";
        }
        super.setEncoding(encoding);
    }

    protected void sendChar(char chKey, boolean altKeyPressed) {
        if (altKeyPressed && IGNORE_ALT_WITH_KEYS.contains(Character.valueOf(chKey))) {
            altKeyPressed = false;
        }
        super.sendChar(chKey, altKeyPressed);
    }

    public void disposeTerminal() {
        JFaceResources.getFontRegistry().removeListener(this.propertyChangeListener);
        InstanceScope.INSTANCE.getNode("com.aptana.theme").removePreferenceChangeListener(this.preferenceChangeListener);
        super.disposeTerminal();
    }

    protected org.eclipse.tm.internal.terminal.textcanvas.TextCanvas createTextCanvas(Composite parent, ITextCanvasModel canvasModel, ILinelRenderer linelRenderer) {
        return new TextCanvas(parent, canvasModel, 0, linelRenderer, this.hyperlinkManager);
    }

    protected ILinelRenderer createLineRenderer(ITextCanvasModel model) {
        this.hyperlinkManager = new HyperlinkManager(model.getTerminalText());
        return new ThemedTextLineRenderer(model, this.hyperlinkManager);
    }
}

